import java.util.concurrent.Flow;

public class DemoSubscriber implements Flow.Subscriber<Integer> {
	private static int subCum;
	private final int subNo;
	private static int protInt = 1000;
	private Flow.Subscription subscription;

	DemoSubscriber() {
		subNo = ++subCum;
	}

	@Override
	public void onSubscribe(Flow.Subscription subscr) {
//		if (subNo % protInt == 0)
//			System.out.println("Subscriber " + subNo + " hat ein Subscription-Objekt erhalten");
		subscription = subscr;
		subscription.request(1);
	}

	@Override
	public void onNext(Integer ipar) {
//		if (subNo % protInt == 0)
//			System.out.println("Subscriber " + subNo + " hat erhalten: " + ipar);
		try {Thread.sleep(100);
		} catch (InterruptedException ix) { /* Ignorieren ist OK, weil kein Interrupt signalisiert wird.*/ }
		subscription.request(1);
	}

	@Override
	public void onError(Throwable ex) {
		if (subNo % protInt == 0)
			System.out.println("Der Subscriber " + subNo + " hat einen onError() - Aufruf erhalten: " + ex.getMessage());
	}

	@Override
	public void onComplete() {
//		if (subNo % protInt == 0)
//			System.out.println("Der Subscriber " + subNo + " hat einen onComplete() - Aufruf erhalten.");
	}
}
